/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import net.adventurez.entity.NecromancerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WitherPuppetEntity
extends Monster {
    private Mob owner;
    private boolean alive;
    private int lifeTicks;

    public WitherPuppetEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 0;
    }

    public static AttributeSupplier.Builder createWitherPuppetAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 38.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{NecromancerEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.f_21346_.m_25352_(3, (Goal)new TrackOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("LifeTicks")) {
            this.setLifeTicks(tag.m_128451_("LifeTicks"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.alive) {
            tag.m_128405_("LifeTicks", this.lifeTicks);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.alive && --this.lifeTicks <= 0) {
            this.lifeTicks = 20;
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
        }
        if (this.owner != null && this.owner.f_20919_ > 0) {
            this.m_146870_();
            this.m_21373_();
        }
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public void setLifeTicks(int lifeTicks) {
        this.alive = true;
        this.lifeTicks = lifeTicks;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12562_, 0.5f, 1.0f);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19615_ ? false : super.m_7301_(effect);
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7327_(Entity target) {
        if (!this.m_9236_().m_5776_() && target instanceof LivingEntity && this.m_9236_().m_213780_().m_188503_(5) == 0) {
            ((LivingEntity)target).m_147207_(new MobEffectInstance(MobEffect.m_19453_((int)18), 80, 0, false, false), (Entity)this);
        }
        return super.m_7327_(target);
    }

    class TrackOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions TRACK_OWNER_PREDICATE;

        public TrackOwnerTargetGoal(PathfinderMob mob) {
            super((Mob)mob, false);
            this.TRACK_OWNER_PREDICATE = TargetingConditions.m_148352_().m_26883_(80.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return WitherPuppetEntity.this.owner != null && WitherPuppetEntity.this.owner.m_5448_() != null && this.m_26150_(WitherPuppetEntity.this.owner.m_5448_(), this.TRACK_OWNER_PREDICATE);
        }

        public void m_8056_() {
            WitherPuppetEntity.this.m_6710_(WitherPuppetEntity.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

